<?php
// PRIVATECONTENT USER ACTIVITIES ADD-ON INTEGRATION


// INJECT ACTIVITY TYPE GROUP
function pcma_pcua_act_type_groups($groups) {
    $groups['pcma'] = __('Mail Actions add-on', PCMA_ML);
    return $groups;
}
add_filter('pcua_act_type_groups', 'pcma_pcua_act_type_groups'); 





// ACTIVITY TYPES
function pcma_pcua_act_types($at) {
    $ml_key = PCMA_ML;
    
    // user validated its email
    $at['pcma_validated_email'] = array(
        'name'  => __('User validated e-mail address', $ml_key),
        'helper'=> __('Reporting whenever user validates its e-mail address', $ml_key),
        'group' => 'pcma',
        'metas' => array(),
    );
    
    return $at;
}
add_filter('pcua_act_types', 'pcma_pcua_act_types');








// ACTIVITY TRIGGERS
/*
array(
    'trigger_slug' => array(
        'act_type' => activity_slug,
        'trig_type' => wp_hook || js_event
        'helper' =>,
        'js_event' => array(
            'selector' =>,
            'event' =>,
            'is_jquery' => 1|0,
            'once_per_page' => 1|0,
        ),
        'wp_hook' => array(
            'type' => action || filter,
            'name' => ,
        ),
        'meta_assoc'=> array(
            'type_meta_slug'   => JS code returning a value (if js_event)
            'type_meta_slug'   => e.attr_name (if js_event > e is event object)
            'type_meta_slug'   => (int) jquery custom param num (if jquery js_event)

            'type_meta_slug'   => (int) hook param num (if wp_hook)
            'type_meta_slug'   => (string) PHP function name (if wp_hook)
        )
    )
) 
*/
function pcma_pcua_act_triggers($atrig) {
    $ml_key = PCMA_ML;
    
    // user paid for a subscription
    $atrig['pcma_validated_email'] = array(
        'act_type'  => 'pcma_validated_email',
        'trig_type' => 'wp_hook',
        'helper'    => __('Official way to know when users validate their e-mail address through Mail Actions add-on', $ml_key),
        
        'wp_hook' => array(
            'type' => 'action',
            'name' => 'pcma_user_verified_email',
        ),
        'meta_assoc' => array(),
    );
    
    return $atrig;
}
add_filter('pcua_act_triggers', 'pcma_pcua_act_triggers');







// set user ID for pcma_validated_email activities
function pcma_acts_set_uid($uid, $act_slug, $hook_vars, $act_params, $act_metas) {
    if($act_slug == 'pcma_validated_email') {
        return $hook_vars[0];
    }
    return $uid;
}
add_filter('pcua_add_act_from_trigger_uid', 'pcma_acts_set_uid', 10, 5);




// strip extra parameters from e-mail validation page URL
function pcma_pcua_act_url($url, $act_slug, $params) {
    if($act_slug == 'pcma_validated_email') {
        $url = remove_query_arg('pcma_user', $url);
        $url = remove_query_arg('pcma_key', $url);
    }
    return $url;
}
add_filter('pcua_act_url', 'pcma_pcua_act_url', 10, 3);